	function [G, Z, R_ZEROS, P, Wsnew] = BW_POLES_S(Wc, Ws, Amax, Amin, N)
	
	% 	Computes the denormalized poles, zeros, and gain constant for  
	%	an analog lowpass Butterworth filter with |H(0)| = 1.
	%	The design margin is used to decreae the stopband edge.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 1986-9-27
	% 	Modified by: 	LW 2000-10-31, 2002-07-28, 2004-09-22, 2013-12-29
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	%
	
	if floor(N) ~= -floor(-N)
		disp('N must be an interger')
		return
	end
	if ~(abs(N-round(N)) < eps)
		N = floor(BW_ORDER_S(Wc, Ws, Amax, Amin)) + 1;
		return
	end
	if (Wc >= Ws)
		error('Not a lowpass filter. Must have Wc < Ws')  
	elseif ( Amax <= 0 | Amax >= Amin)
		error('The passband attenuation must be 0 < Amax < Amin')
	elseif ( Amin <= 0)
		error('The stopband attenuation must be Amin > Amax > 0')
	end 
	Z = [];
	P = [];
	Apn = Amax*log(10)/20;
	epsilon = sqrt(2*exp(Apn)*sinh(Apn));
	rp0 = Wc*epsilon^(-1/N);
	odd = rem(N, 2);
	if odd == 1
		M = (N+1)/2; 
	else
		M = N/2;
	end
	for k = 1:M
		X = rp0*exp(i*(N-1+2*k)*pi/(2*N));
		if ~(odd == 1 & k == M)
			P = [conj(X); X; P];
		else
			P = [X; P];
		end
	end
	G = rp0^N;	% Gain constant
	% The reflection zeros are
	R_ZEROS = zeros(N, 1);
	X = log10((10^(0.1*Amin)-1)/(2*exp(Apn)*sinh(Apn)))/2;
	Wsnew = Wc*10^(X/N);
	
	
